/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.tags;

import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.StringTag;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NumberTag
extends StringTag {
    public NumberTag(Element auimlElement, Document hmcmlDocument, String resource, String[] resources) {
        super(auimlElement, hmcmlDocument, resource, resources);
    }

    public void startHMCMLTag() {
        super.startHMCMLTag();
        String tagName = this.getHmcmlElement().getTagName();
        if (tagName.equals("WTextEntry")) {
            this.getHmcmlElement().setAttribute("maxLength", new Integer(this.figureMaxLength()).toString());
        }
    }

    public void addValidator() {
        if (!(this.type.equals("LABEL") || this.isChoiceElement() || this.type.equals("LIST"))) {
            String formatBinding;
            String mandatory;
            String max;
            String min = this.getAttribute("MIN");
            if (min == null) {
                min = "";
            }
            if ((max = this.getAttribute("MAX")) == null) {
                max = "";
            }
            if ((mandatory = this.getAttribute("MANDATORY")) == null) {
                mandatory = "FALSE";
            }
            if ((formatBinding = this.getAttribute("FORMAT-BINDING")) == null) {
                formatBinding = "";
            }
            Element auimlFormatter = this.hmcmlDocument.createElementNS("hmc", "Format");
            auimlFormatter.setAttribute("class", "com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters.AuimlDefaultFormatter");
            auimlFormatter.setAttribute("FORMAT-BINDING", formatBinding);
            auimlFormatter.setAttribute("required", mandatory);
            if (this.isRealNumberProperty()) {
                this.type = "REAL";
            } else {
                this.type = "INTEGRAL";
                if (!max.equals("")) {
                    max = new Integer(new Double(max).intValue()).toString();
                }
                if (!min.equals("")) {
                    min = new Integer(new Double(min).intValue()).toString();
                }
            }
            auimlFormatter.setAttribute("maxValue", max);
            auimlFormatter.setAttribute("minValue", min);
            auimlFormatter.setAttribute("type", this.type);
            String increment = this.getAttribute("INCREMENT");
            if (increment != null && !increment.equals("")) {
                auimlFormatter.setAttribute("increment", increment);
            }
            if (!(min.equals("") && max.equals("") && mandatory.equals("FALSE") && formatBinding.equals(""))) {
                this.getHmcmlElement().appendChild(auimlFormatter);
            }
        }
    }

    private int figureMaxLength() {
        int numChars;
        String precision;
        String max;
        String min = this.getAttribute("MIN");
        if (min == null) {
            min = "12345678901234567890";
        }
        if ((max = this.getAttribute("MAX")) == null) {
            max = "12345678901234567890";
        }
        if ((precision = this.getAttribute("PRECISION")) == null) {
            precision = "";
        }
        if ((numChars = Math.max(min.length(), max.length())) == 0) {
            numChars = 20;
        }
        try {
            int p;
            if (!precision.equals("") && (p = Integer.parseInt(precision)) > 0) {
                numChars += p + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return numChars;
    }

    private boolean isRealNumberProperty() {
        String precision = this.getAttribute("PRECISION");
        if (precision == null) {
            precision = "";
        }
        try {
            if (!precision.equals("")) {
                int x = Integer.parseInt(precision);
                if (x > 0) {
                    return true;
                }
                if (x == 0) {
                    return false;
                }
            }
            String binding = this.getAttribute("BINDING");
            String className = binding.substring(0, binding.indexOf("#"));
            Class<?> beanClass = Class.forName(className);
            String propertyName = this.getBindingProperty();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pd = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                Class<?> propertyClass;
                if (!propertyName.equals(pd[i].getName()) || !(propertyClass = pd[i].getPropertyType()).getName().equals("double")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

